function [k,theta,sigma,L,mu,x0] = generate_parameter_time_series(AJD, used_dates, x0)
% --------------------------------------------------------------------------------------------------
% Extract time-series of parameters from AJD (if they are a time-series), otherwise generate time
% series from the constant values.
% --------------------------------------------------------------------------------------------------
% AJD           ... parameter vector with AJD dynamics
% used_date     ... dates of interest
% x0            ... (optional) starting value of AJD
% --------------------------------------------------------------------------------------------------
% sample call: generate_parameter_time_series(cdx_new2b.AJD_common_factor, cdx_new2b.AJD_common_factor.dates, 0.02)
% --------------------------------------------------------------------------------------------------

if (isfield(AJD, 'dates'))
    [trash, used_range] = is_member_sorted_c(used_dates, AJD.dates);
    used_range = used_range(used_range > 0);
    num_dates = numel(used_range);
else
    num_dates = length(used_dates);
end

% Cut down time series of parameters to relevant range
if (numel(AJD.k) > 1)
    k = AJD.k(used_range);
else
    k = AJD.k(ones(num_dates,1));
end
if (numel(AJD.theta) > 1)
    theta = AJD.theta(used_range);
else
    theta = AJD.theta(ones(num_dates,1));
end
if (numel(AJD.sigma) > 1)
    sigma = AJD.sigma(used_range);
else
    sigma = AJD.sigma(ones(num_dates,1));
end
if (numel(AJD.L) > 1)
    L = AJD.L(used_range);
else
    L = AJD.L(ones(num_dates,1));
end
if (numel(AJD.mu) > 1)
    mu = AJD.mu(used_range);
else
    mu = AJD.mu(ones(num_dates,1));
end
if (nargin > 2)
    if (numel(x0) > 1)
        x0 = x0(used_range);
    else
        x0 = x0(ones(num_dates,1));
    end
end